/*
 * Decompiled with CFR 0.152.
 */
package us.almy.represent;

import java.util.StringTokenizer;

public class Conversions {
    private boolean spacing = false;
    private boolean bigendian = false;
    private int outRadix = 16;
    private boolean outOctal = false;
    private static final String[] ASCIICC = new String[]{"NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL", "BS", "HT", "LF", "VT", "FF", "CR", "SO", "SI", "DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB", "CAN", "EM", "SUB", "ESC", "FS", "GS", "RS", "US", "sp"};

    public boolean isOutOctal() {
        return this.outOctal;
    }

    public void setOutOctal(boolean outOctal) {
        this.outRadix = outOctal ? 8 : 16;
        this.outOctal = outOctal;
    }

    public boolean isSpacing() {
        return this.spacing;
    }

    public void setSpacing(boolean spacing) {
        this.spacing = spacing;
    }

    public boolean isBigendian() {
        return this.bigendian;
    }

    public void setBigendian(boolean bigendian) {
        this.bigendian = bigendian;
    }

    private String leftSpace(String val) {
        boolean isNegative;
        boolean bl = isNegative = val.charAt(0) == '-';
        if (isNegative) {
            val = val.substring(1);
        }
        String negSign = isNegative ? "-" : "";
        int length = val.length();
        if (length <= 3) {
            return negSign + val;
        }
        StringBuffer sb = new StringBuffer(negSign);
        int size = length % 3;
        if (size == 0) {
            size = 3;
        }
        int iterations = (length + 2) / 3;
        int j = 0;
        for (int i = 0; i < iterations; ++i) {
            sb.append(val.substring(j, j + size));
            j += size;
            size = 3;
            if (i >= iterations - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private String rightSpace(String val) {
        int length = val.length();
        StringBuffer sb = new StringBuffer();
        int iterations = (length + 2) / 3;
        for (int i = 0; i < iterations; ++i) {
            sb.append(val.substring(i * 3, Math.min(i * 3 + 3, length)));
            if (i >= iterations - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private String spaceLong(long lval) {
        String val = Long.toString(lval);
        if (!this.spacing) {
            return val;
        }
        return this.leftSpace(val);
    }

    private String spaceDouble(double dval) {
        String val = Double.toString(dval);
        if (!this.spacing) {
            return val;
        }
        if (val.contains(".")) {
            int pos = val.indexOf(".");
            if (val.contains("E")) {
                int epos = val.indexOf("E");
                return this.leftSpace(val.substring(0, pos)) + "." + this.rightSpace(val.substring(pos + 1, epos)) + val.substring(epos);
            }
            return this.leftSpace(val.substring(0, pos)) + "." + this.rightSpace(val.substring(pos + 1));
        }
        return this.leftSpace(val);
    }

    private String spaceHex(String val) {
        if (!this.spacing) {
            return val;
        }
        int length = val.length();
        if (length <= 4) {
            return val;
        }
        StringBuffer sb = new StringBuffer();
        int size = length % 4;
        if (size == 0) {
            size = 4;
        }
        int iterations = (length + 3) / 4;
        int j = 0;
        for (int i = 0; i < iterations; ++i) {
            sb.append(val.substring(j, j + size));
            j += size;
            size = 4;
            if (i >= iterations - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private String spaceHexFrac(String val) {
        if (!this.spacing) {
            return val;
        }
        int length = val.length();
        StringBuffer sb = new StringBuffer();
        int iterations = (length + 3) / 4;
        for (int i = 0; i < iterations; ++i) {
            sb.append(val.substring(i * 4, Math.min(i * 4 + 4, length)));
            if (i >= iterations - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private String processLongValue(long longValue) {
        boolean neg24;
        StringBuffer sb = new StringBuffer();
        boolean neg8 = (longValue & 0xFFFFFFFFFFFFFF80L) == 128L;
        boolean neg16 = (longValue & 0xFFFFFFFFFFFF8000L) == 32768L;
        boolean neg32 = (longValue & Integer.MIN_VALUE) == 0x80000000L;
        boolean neg12 = this.isOutOctal() && (longValue & 0xFFFFFFFFFFFFF800L) == 2048L;
        boolean bl = neg24 = this.isOutOctal() && (longValue & 0xFFFFFFFFFF800000L) == 0x800000L;
        if (this.isOutOctal()) {
            if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
                sb.append("Octal: " + this.spaceHex(Integer.toOctalString((int)longValue)) + "\n");
            } else {
                sb.append("Octal: " + this.spaceHex(Long.toOctalString(longValue)) + "\n");
            }
        } else if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
            sb.append("Hexadecimal: " + this.spaceHex(Integer.toHexString((int)longValue)) + "\n");
        } else {
            sb.append("Hexadecimal: " + this.spaceHex(Long.toHexString(longValue)) + "\n");
        }
        if (longValue < 0L || !neg8 && !neg16 && !neg32 && !neg12) {
            sb.append("Decimal: " + this.spaceLong(longValue) + "\n");
        } else if (neg8) {
            sb.append("Decimal: " + this.spaceLong(longValue) + " or signed 8-bit " + this.spaceLong(longValue - 256L) + "\n");
        } else if (neg12) {
            sb.append("Decimal: " + this.spaceLong(longValue) + " or signed 12-bit " + this.spaceLong(longValue - 4096L) + "\n");
        } else if (neg16) {
            sb.append("Decimal: " + this.spaceLong(longValue) + " or signed 16-bit " + this.spaceLong(longValue - 65536L) + "\n");
        } else if (neg24) {
            sb.append("Decimal: " + this.spaceLong(longValue) + " or signed 24-bit " + this.spaceLong(longValue - 0x1000000L) + "\n");
        } else {
            sb.append("Decimal: " + this.spaceLong(longValue) + " or signed 32-bit" + this.spaceLong(longValue - 0x100000000L) + "\n");
        }
        if (!(longValue >= 0L && (neg8 || neg12 || neg16 || neg24 || neg32))) {
            sb.append("Decimal, scaled 8 bits: " + this.spaceDouble((double)longValue / 256.0) + "\n");
        } else if (neg8) {
            sb.append("Decimal, scaled 8 bits: " + this.spaceDouble((double)longValue / 256.0) + " or signed 8-bit " + this.spaceDouble((double)(longValue - 256L) / 256.0) + "\n");
        } else if (neg12) {
            sb.append("Decimal, scaled 8 bits: " + this.spaceDouble((double)longValue / 256.0) + " or signed 12-bit " + this.spaceDouble((double)(longValue - 4096L) / 256.0) + "\n");
        } else if (neg16) {
            sb.append("Decimal, scaled 8 bits: " + this.spaceDouble((double)longValue / 256.0) + " or signed 16-bit " + this.spaceDouble((double)(longValue - 65536L) / 256.0) + "\n");
        } else if (neg24) {
            sb.append("Decimal, scaled 8 bits: " + this.spaceDouble((double)longValue / 256.0) + " or signed 24-bit " + this.spaceDouble((double)(longValue - 0x1000000L) / 256.0) + "\n");
        } else {
            sb.append("Decimal, scaled 8 bits: " + this.spaceDouble((double)longValue / 256.0) + " or signed 32-bit" + this.spaceDouble((double)(longValue - 0x100000000L) / 256.0) + "\n");
        }
        if (this.isOutOctal()) {
            if (longValue < 0L || !neg12 && !neg16 && !neg24 && !neg32) {
                sb.append("Decimal, scaled 12 bits: " + this.spaceDouble((double)longValue / 4096.0) + "\n");
            } else if (neg12) {
                sb.append("Decimal, scaled 12 bits: " + this.spaceDouble((double)longValue / 4096.0) + " or signed 12 bit " + this.spaceDouble((double)(longValue - 4096L) / 4096.0) + "\n");
            } else if (neg16) {
                sb.append("Decimal, scaled 12 bits: " + this.spaceDouble((double)longValue / 4096.0) + " or signed 16-bit " + this.spaceDouble((double)(longValue - 65536L) / 4096.0) + "\n");
            } else if (neg24) {
                sb.append("Decimal, scaled 12 bits: " + this.spaceDouble((double)longValue / 4096.0) + " or signed 24-bit " + this.spaceDouble((double)(longValue - 0x1000000L) / 4096.0) + "\n");
            } else {
                sb.append("Decimal, scaled 12 bits: " + this.spaceDouble((double)longValue / 4096.0) + " or signed 32-bit" + this.spaceDouble((double)(longValue - 0x100000000L) / 4096.0) + "\n");
            }
        }
        if (longValue < 0L || !neg16 && !neg32) {
            sb.append("Decimal, scaled 16 bits: " + this.spaceDouble((double)longValue / 65536.0) + "\n");
        } else if (neg16) {
            sb.append("Decimal, scaled 16 bits: " + this.spaceDouble((double)longValue / 65536.0) + " or signed 16-bit " + this.spaceDouble((double)(longValue - 65536L) / 65536.0) + "\n");
        } else {
            sb.append("Decimal, scaled 16 bits: " + this.spaceDouble((double)longValue / 65536.0) + " or signed 32-bit" + this.spaceDouble((double)(longValue - 0x100000000L) / 65536.0) + "\n");
        }
        if (longValue < 0L || !neg24 && !neg32) {
            sb.append("Decimal, scaled 24 bits: " + this.spaceDouble((double)longValue / 1.6777216E7) + "\n");
        } else if (neg24) {
            sb.append("Decimal, scaled 24 bits: " + this.spaceDouble((double)longValue / 1.6777216E7) + " or signed 24-bit " + this.spaceDouble((double)(longValue - 0x1000000L) / 1.6777216E7) + "\n");
        } else {
            sb.append("Decimal, scaled 24 bits: " + this.spaceDouble((double)longValue / 1.6777216E7) + " or signed 32-bit" + this.spaceDouble((double)(longValue - 0x100000000L) / 1.6777216E7) + "\n");
        }
        if (longValue < 0L || !neg32) {
            sb.append("Decimal, scaled 32 bits: " + this.spaceDouble((double)longValue / 4.294967296E9) + "\n");
        } else {
            sb.append("Decimal, scaled 32 bits: " + this.spaceDouble((double)longValue / 4.294967296E9) + " or signed 32-bit" + this.spaceDouble((double)(longValue - 0x100000000L) / 4.294967296E9) + "\n");
        }
        if (longValue <= 0xFFFFFFFFL) {
            sb.append("32-bit IEEE FP: " + Float.intBitsToFloat((int)longValue) + "\n");
        }
        sb.append("64-bit IEEE FP: " + Double.longBitsToDouble(longValue) + "\n");
        if (longValue >= 0L) {
            if (longValue < 256L) {
                sb.append("ASCII/Unicode character: ");
                if (longValue < 32L || longValue > 127L && longValue < 160L) {
                    sb.append("[" + ASCIICC[0x7F & (int)longValue] + "]\n");
                } else if (longValue == 127L) {
                    sb.append("[DEL]\n");
                } else {
                    sb.append("'" + Character.toString((char)longValue) + "'\n");
                }
            } else {
                if (longValue < 65536L) {
                    sb.append("Unicode character: '" + Character.toString((char)longValue) + "'\n");
                }
                sb.append("ASCII string \"");
                if (this.bigendian) {
                    boolean skipping = true;
                    for (int i = 56; i >= 0; i -= 8) {
                        int val = (int)(longValue >>> i) & 0xFF;
                        if (val == 0 && skipping) continue;
                        if (val < 32) {
                            sb.append("\u2588");
                        } else {
                            sb.append(Character.toString((char)val));
                        }
                        skipping = false;
                    }
                } else {
                    while (longValue != 0L) {
                        if ((longValue & 0xFFL) < 32L) {
                            sb.append("\u2588");
                        } else {
                            sb.append(Character.toString((char)(longValue & 0xFFL)));
                        }
                        longValue >>>= 8;
                    }
                }
                sb.append("\"\n");
            }
        }
        return sb.toString();
    }

    private String processHex(String t) {
        long longValue;
        try {
            longValue = Long.parseLong(t, 16);
        }
        catch (NumberFormatException ex) {
            return "Invalid number format";
        }
        return this.processLongValue(longValue);
    }

    private String processOctal(String t) {
        long longValue;
        try {
            longValue = Long.parseLong(t, 8);
        }
        catch (NumberFormatException ex) {
            return "Invalid number format";
        }
        return this.processLongValue(longValue);
    }

    private String processChar(String t) {
        int stringLength = t.length();
        if (stringLength > 4) {
            return "String size limited to 4 characters";
        }
        long resultValue = 0L;
        for (int i = 0; i < stringLength; ++i) {
            char charValue = t.charAt(this.bigendian ? i : stringLength - 1 - i);
            if (charValue > '\u00ff') {
                return "ASCII characters only, '" + charValue + "' not allowed.";
            }
            resultValue = (resultValue << 8) + (long)charValue;
        }
        if (this.isOutOctal()) {
            return "Decimal integer: " + resultValue + "\n" + "Octal: " + Integer.toOctalString((int)resultValue);
        }
        return "Decimal integer: " + resultValue + "\n" + "Hexadecimal: " + Integer.toHexString((int)resultValue);
    }

    private String twoDigitChar(char x) {
        String s = Integer.toHexString(x);
        return s.length() == 1 ? "0" + s : s;
    }

    private String threeDigitChar(char x) {
        String s = Integer.toOctalString(x);
        return s.length() == 1 ? "00" + s : (s.length() == 2 ? "0" + s : s);
    }

    private String processString(String t) {
        int i;
        StringBuffer result = new StringBuffer();
        int length = t.length();
        if (this.isOutOctal()) {
            result.append("Octal bytes:");
            for (i = 0; i < length; ++i) {
                result.append(" " + this.threeDigitChar(t.charAt(i)));
            }
        } else {
            result.append("Hex bytes:");
            for (i = 0; i < length; ++i) {
                result.append(" " + this.twoDigitChar(t.charAt(i)));
            }
        }
        result.append("\nDecimal bytes:");
        for (i = 0; i < length; ++i) {
            result.append(" " + t.charAt(i));
        }
        return result.toString();
    }

    private String processFloat(String t) {
        String fullString;
        boolean sign;
        double doubleValue;
        try {
            doubleValue = Double.parseDouble(t);
        }
        catch (NumberFormatException ex) {
            return "Invalid format";
        }
        StringBuffer result = new StringBuffer();
        if (this.isOutOctal()) {
            result.append("IEEE 32-bit FP: " + this.spaceHex(Integer.toOctalString(Float.floatToIntBits((float)doubleValue))) + "\n");
            result.append("IEEE 64-bit FP: " + this.spaceHex(Long.toOctalString(Double.doubleToLongBits(doubleValue))) + "\n");
        } else {
            result.append("IEEE 32-bit FP: " + this.spaceHex(Integer.toHexString(Float.floatToIntBits((float)doubleValue))) + "\n");
            result.append("IEEE 64-bit FP: " + this.spaceHex(Long.toHexString(Double.doubleToLongBits(doubleValue))) + "\n");
        }
        boolean bl = sign = doubleValue < 0.0;
        if (sign) {
            doubleValue = -doubleValue;
        }
        if (doubleValue < 32768.0) {
            fullString = Long.toHexString((long)((sign ? -doubleValue : doubleValue) * 2.81474976710656E14));
            if (fullString.length() < 13) {
                fullString = "0000000000000".substring(fullString.length()) + fullString;
            }
            result.append("Hex fixed point: " + this.spaceHex(fullString.substring(0, fullString.length() - 12)) + "." + this.spaceHexFrac(fullString.substring(fullString.length() - 12)) + "\n");
        } else if (doubleValue < 2.147483648E9) {
            fullString = Long.toHexString((long)((sign ? -doubleValue : doubleValue) * 4.294967296E9));
            if (fullString.length() < 9) {
                fullString = "00000000".substring(fullString.length()) + fullString;
            }
            result.append("Hex fixed point: " + this.spaceHex(fullString.substring(0, fullString.length() - 8)) + "." + this.spaceHexFrac(fullString.substring(fullString.length() - 8)) + "\n");
        }
        if (doubleValue <= 65535.0) {
            double error;
            int denominator;
            int bestnumerator = 0;
            int bestdenominator = 0;
            double bestError = 65535.0;
            boolean betterUnsigned = true;
            if (doubleValue <= 32767.0) {
                int numerator;
                betterUnsigned = false;
                for (denominator = 1; denominator < Short.MAX_VALUE && (numerator = (int)Math.round(doubleValue * (double)denominator)) <= Short.MAX_VALUE; ++denominator) {
                    error = Math.abs((double)numerator / (double)denominator - doubleValue);
                    if (!(error < bestError)) continue;
                    bestError = error;
                    bestnumerator = numerator;
                    bestdenominator = denominator;
                }
                result.append("16-bit signed fractional scale factor: " + (sign ? "-" : "") + bestnumerator + "/" + bestdenominator + "\n");
            }
            if (doubleValue <= 65535.0 && !sign) {
                int numerator;
                for (denominator = 1; denominator < 65535 && (numerator = (int)Math.round(doubleValue * (double)denominator)) <= 65535; ++denominator) {
                    error = Math.abs((double)numerator / (double)denominator - doubleValue);
                    if (!(error < bestError)) continue;
                    betterUnsigned = true;
                    bestError = error;
                    bestnumerator = numerator;
                    bestdenominator = denominator;
                }
                if (betterUnsigned) {
                    result.append("16-bit fractional scale factor: " + bestnumerator + "/" + bestdenominator + "\n");
                }
            }
        }
        return result.toString();
    }

    private String processInt(String t) {
        long longValue;
        try {
            longValue = Long.parseLong(t);
        }
        catch (NumberFormatException ex) {
            return "Invalid number format";
        }
        return this.processLongValue(longValue);
    }

    private String processCharacterList(String t) {
        StringBuffer sb = new StringBuffer();
        int radix = 10;
        if (t.startsWith("0x")) {
            radix = 16;
            t = t.substring(2);
        } else if (t.startsWith("$")) {
            radix = 16;
            t = t.substring(1);
        } else if (t.startsWith("0") && t.length() > 1 && t.charAt(1) != ' ') {
            radix = 8;
            t = t.substring(1);
        }
        StringTokenizer st = new StringTokenizer(t);
        while (st.hasMoreTokens()) {
            int val;
            String s = st.nextToken();
            try {
                val = Integer.parseInt(s, radix);
                if (val > 65535 || val < 0) {
                    return "Value out of range: " + s + "\n";
                }
            }
            catch (NumberFormatException e) {
                return "Invalid value: " + s + "\n";
            }
            if (val < 33 || val > 127 && val < 160) {
                sb.append(ASCIICC[0x7F & val] + " ");
                continue;
            }
            if (val == 127) {
                sb.append("DEL ");
                continue;
            }
            sb.append(Character.toString((char)val) + " ");
        }
        return sb.toString() + "\n";
    }

    public String performConversion(String t) {
        String result = null;
        while (t.startsWith(" ")) {
            t = t.substring(1);
        }
        result = t.startsWith("'") ? this.processChar(t.substring(1)) : (t.startsWith("\"") ? this.processString(t.substring(1)) : (t.contains(" ") ? this.processCharacterList(t) : (t.startsWith("0x") ? this.processHex(t.substring(2)) : (t.startsWith("$") ? this.processHex(t.substring(1)) : (t.contains(".") || t.contains("e") || t.contains("E") ? this.processFloat(t) : (t.startsWith("0") ? this.processOctal(t) : this.processInt(t)))))));
        return result;
    }

    public String getHelpString() {
        String helpString = "Value can be one of the following formats:\n'c where c is 1 to 4 characters considered packed into a word\n\"s where s is a string of characters, including Unicode\n0xn where n is a hexadecimal value of up to 64 bits\n$n where n is a hexadecimal value of up to 64 bits\n0n where n is an octal value of up to 64 bits\nA floating point value which must contain a decimal point or exponent\nA decimal integer with optional leading minus sign\nMultiple integer values to be converted to\n    an ASCII or Unicode character string. Values are\n    decimal unless the values start with \"0x\", \"$\" or \"0\"";
        return helpString;
    }
}

